from unittest.mock import patch, Mock
from mailer import send
import smtplib


def test_send_unittest():
    sender = "jan.kowal@poczta.com"
    to = "jan.kowal@poczta.com"
    body = "Witaj, Asiu!"
    subject = "Co u Ciebie?"

    with patch("smtplib.SMTP") as mock:
        client = mock.return_value
        client.sendmail.return_value = {}

        res = send(sender, to, subject, body)

        assert client.sendmail.called
        assert client.sendmail.call_args[0][0] == sender
        assert client.sendmail.call_args[0][1] == to
        assert subject in client.sendmail.call_args[0][2]
        assert body in client.sendmail.call_args[0][2]
        assert res == {}


def test_send(monkeypatch):
    sender = "jan.kowal@poczta.com"
    to = "jan.kowal@poczta.com"
    body = "Witaj, Asiu!"
    subject = "Co u Ciebie?"

    smtp = Mock()
    monkeypatch.setattr(smtplib, "SMTP", smtp)
    client = smtp.return_value
    client.sendmail.return_value = {}

    res = send(sender, to, subject, body)

    assert client.sendmail.called
    assert client.sendmail.call_args[0][0] == sender
    assert client.sendmail.call_args[0][1] == to
    assert subject in client.sendmail.call_args[0][2]
    assert body in client.sendmail.call_args[0][2]
    assert res == {}
